/*

========================================================

 File   : MAIN.H (program body source file header)
 Program: AFaustas Text Editor 1.0
 Author : Azuolas - Faustas Bagdonas
 Date   : 2009-07 -- 2009-08

--------------------------------------------------------

 Description:

 AFaustas Text Editor - tai  labai  paprastas  tekstinis
 redaktorius DOS operacinei sistemai. Si  programa  buvo
 parasyta pazintiniais tikslais ir joje yra gausu  neis-
 taisytu bug'u, todel jos NEREKOMENDUOJAMA naudot darbui
 su svarbiais failais.

 Ateityje planuoju sia programa padaryti  panasia i "VI"
 redaktoriu UNIX operacinei sistemai.

--------------------------------------------------------
 (c) Copyright 2009, Azuolas - Faustas BAGDONAS
========================================================

*/

#ifndef __MAIN_H

 #define __MAIN_H
 #include <stdio.h>
 #include <stdlib.h>
 #include <string.h>
 #include <conio.h>
 #include <alloc.h>
 #include <dos.h>
 #pragma hdrstop

 #define TRUE           1
 #define FALSE          0

 #define MAIN_WINDOW    1
 #define COMMAND        2
 #define DISP_FILEC     3
 #define CLEAR_MAINW    4

 #define ESC         0x001B
 #define ENTER       0x000D
 #define SPACE       0x0020
 #define PGDOWN      0x5100
 #define PGUP        0x4900
 #define UP          0x4800
 #define DOWN        0x5000
 #define RIGHT       0x4D00
 #define LEFT        0x4B00
 #define INSERT      0x5200

 #define PR_NORST       2

 typedef int BOOL;
 typedef struct {
		  char fname[128];
		  FILE *failas;
		  unsigned long int size ;
		  BOOL ReadOnly;
		} FDATA;
 typedef struct {
		  int x;
		  unsigned long int y;
		} CURSOR;

 #include "pseudo.h"
 #include "errors.h"

 /* Global Variables */

 char far **data;
 unsigned long linesloaded = 0;
 //unsigned long curline = 0;
 FDATA fdata;
 CURSOR datapos;
 BOOL insertstate = TRUE;
 BOOL modified = FALSE;

 /* Function prototypes */

 void splash (void);

 FILE *openfile (void);
 BOOL loadfile (FILE *failas);
 unsigned long int getfilesize(FILE *failas);
 void updateposinfo (void);
 BOOL save(char *fname);
 BOOL filecopy (char *dst, char *src);

 void setui (int mode);
 int getinput(void);
 int proceedinput (int input, int uimode); //Return uimode
 BOOL proccmd (char *cmd);

 //void oomerror(void);
 void pexit(BOOL successful);
 void help (void);

 void freedatamem(void);

 void insert (char symbol);
 void overwrite (char symbol);
 BOOL insertline(void);
 void delsymbol (void);
 void pushkey(char key);

#endif
