/*

========================================================

 File   : MAIN.C (program body source file)
 Program: AFaustas Text Editor 1.0
 Author : Azuolas - Faustas Bagdonas
 Date   : 2009-07 -- 2009-08

--------------------------------------------------------

 Description:

 AFaustas Text Editor - tai  labai  paprastas  tekstinis
 redaktorius DOS operacinei sistemai. Si  programa  buvo
 parasyta pazintiniais tikslais ir joje yra gausu  neis-
 taisytu bug'u, todel jos NEREKOMENDUOJAMA naudot darbui
 su svarbiais failais.

 Ateityje planuoju sia programa padaryti  panasia i "VI"
 redaktoriu UNIX operacinei sistemai.

--------------------------------------------------------
 (c) Copyright 2009, Azuolas - Faustas BAGDONAS
========================================================

*/

#include "main.h"

int main (int argc, char *argv[]){
  FILE *failas = NULL;
  int uiset = 0;
  fdata.ReadOnly = FALSE;
  datapos.x=0; datapos.y=0;

  randomize();

  splash();
  while(1){
    failas = openfile();
    if (failas){
      if (!loadfile(failas))
	return 1;
      setui(MAIN_WINDOW);
      setui(DISP_FILEC);
      gotoxy(1,1);
      datapos.x=datapos.y=0;
      while(failas != NULL){
	int input;

	updateposinfo();
	input = getinput();
	uiset = proceedinput(input, uiset);
	setui(uiset);
	uiset = 0;
      }
    }
  }
  //return 0;
}


void splash (void){
  int delayt = 100;

  textmode(0x03);
  textbackground(CYAN);
  clrscr();
  gotoxy(17, 10);
  textcolor(YELLOW);
  cprintf("        AFaustas Text Editor 1.0 ALPHA");
  gotoxy(17, 12);
  textcolor(BLUE);
  cprintf("(c) Copyright 2009, Azuolas - Faustas Bagdonas");
  gotoxy(1,25);
  textcolor(WHITE);
  cprintf("Press any key to continue...");
  while (!kbhit()){
    delay(10);
    delayt--;
    if (!delayt)
      return;
  }
  getch();


}

 FILE *openfile (void){
   FILE *failas;
   char fname[130]; //128+2
   fname[0]=128;

   /* Gaunamas kelias iki failo */

   textbackground(BLACK);
   clrscr();
   textcolor(LIGHTBLUE);
   cprintf("Enter file name (type EXIT if you want to quit): ");
   textcolor(YELLOW);
   cgets(fname);

   /* Ar uzbaigti programa? */

   if (!strcmp(&fname[2], "EXIT"))
     exit(0);

   /* Bandoma atidaryti faila */

   if ((failas = fopen (&fname[2], "r+"))==NULL){
     if((failas = fopen (&fname[2], "r"))!=NULL)
       fdata.ReadOnly = TRUE;
     else{
       char choice;

       /* Failas nerastas. Sukurti? */

       fdata.ReadOnly = FALSE;
       do{
	 textcolor(RED);
	 cprintf ("\n\rCan't open file \"%s\".\a ", &fname[2]);
	 textcolor(YELLOW);
	 cprintf ("Create new? [Y/N]: ");
	 choice = getche();
	 cprintf ("\n\r");
	 if (choice == 'Y' || choice == 'y'){
	   if ((failas = fopen(&fname[2], "w+"))==NULL){
	     textcolor(RED);
	     cprintf ("File creation failed!");
	     getch();
	   }
	   else{
	     textcolor(LIGHTBLUE);
	     cprintf ("File creation successful.");
	   }
	 }
       }
       while ((choice!='Y')&&(choice!='y')&&(choice!='N')&&(choice!='n'));

     }
   }
   else
     fdata.ReadOnly = FALSE;

   strcpy (fdata.fname, &fname[2]);
   fdata.failas = failas;
   getfilesize(failas);

   return failas;
 }

 BOOL loadfile (FILE *failas){
   char line[356];///!!!!!!!!!!
   unsigned long curline=0, numlines = 0;

   /* Informacija */
   textcolor(YELLOW);
   cprintf("\n\rLoading file into memory...");

   /* Resetinama kursoriaus pozicija */
   datapos.x=datapos.y=0;

   /* Gaunamas eiluciu skaicius */
   while (!feof(failas)){
     BOOL n = (fgetc(failas) == '\n');
     BOOL eof = feof(failas);

     if (n || eof)
       numlines++;
   }

   rewind(failas);

   if (numlines){

     /* Rezervuojama atmintis eiluciu pointeriams */
     data = (char far**)farcalloc(numlines+1, sizeof(char far*));
     if (data == NULL){
       textcolor(RED);
       cprintf("\n\rOut of memory.");
       getch();
       return FALSE;
     }

     while (curline < numlines){ //While not EOF.
       line[0]=0;
       fgets(line, 256, failas);
       if (line[strlen(line) - 1] == '\n')
	 line[strlen(line)-2] = 0;
       data[curline] = (char far*)farmalloc(strlen(line)+1);//!!!
       if (data[curline] == NULL){
	 textcolor(RED);
	 cprintf("\n\rOut of memory.");
	 getch();

	 /* Atlaisvinu rezervuota atminti */

	 for (; curline; curline--){
	   farfree(data[curline]);
	   data[curline] = NULL;
	 }

	 farfree(data);
	 data = NULL;

	 return FALSE;
       }
       _fstrcpy(data[curline], MK_FP(FP_SEG(line), FP_OFF(line)));
       curline++;
     }
   }
   rewind(failas);
   textcolor(YELLOW);
   cprintf("\n\rLoad successful!");
   linesloaded = numlines;
   modified = FALSE;

   return TRUE;
 }

 int proceedinput (int input, int uimode){
   int wx, wy;
   unsigned char bkpdataposx = datapos.x;
   unsigned long int bkpdataposy = datapos.y;

   wx = wherex();
   wy = wherey();

   switch (input){
     case ESC:
       if (uimode != COMMAND)
	 uimode = COMMAND;
       else
	 putch('\a');
       break;
     case PGUP:
       uimode = 0;

       datapos.x -= wherex()-1;
       datapos.y = datapos.y - (wherey()-1) + 23;

       if (datapos.y >= 48)
	 datapos.y -= 48;
       else
	 datapos.y = 0;
       setui(DISP_FILEC);
       if (linesloaded-1>=22)
	 datapos.y -= 22;
       else
	 datapos.y = 0;

       gotoxy(wx, 1);
       datapos.x = bkpdataposx;
       break;

     case PGDOWN:
       {
	 uimode = 0;

	 datapos.x -= wherex()-1;
	 datapos.y = datapos.y - (wherey()-1) + 23;

	 if (!((datapos.y <= linesloaded) && (linesloaded-1 > 22)))
	   datapos.y -= 23;

	 setui(DISP_FILEC);
	 datapos.y--;
	 datapos.x = bkpdataposx;
	 gotoxy(wx, wherey());
       }
       break;
     case UP:
       {
	 uimode = 0;
	 datapos.x -= wherex()-1;

	 if (datapos.y){
	   if (wy!=1){
	     datapos.y--;
	     gotoxy(wx, wy-1);
	   }
	   else{
	     datapos.y--;
	     setui(DISP_FILEC);
	     datapos.y-=wherey()-1; //-23 jei ne pabaiga
	     gotoxy(wx,wy);
	   }
	 }
	 datapos.x = bkpdataposx;
       }
       break;
     case DOWN:
       {
	 uimode = 0;
	 datapos.x -= wherex()-1;

	 if ((datapos.y < linesloaded-1)){
	   if (wy != 23){
	     datapos.y++;
	     gotoxy(wx,wy+1);
	   }
	   else{
	     datapos.y -= 21;
	     setui (DISP_FILEC);
	     gotoxy (wx, wy);

	   }
	 }
	 datapos.x = bkpdataposx;
       }
       break;
     case RIGHT:
       {
	 uimode = 0;
	 datapos.y += 23 - wherey();

	 if (datapos.x < 255){
	   datapos.x++;
	   if (wx == 80){
	     //(linesloaded < 22) ? (datapos.y = 0) : (datapos.y -= 21);
	     datapos.y-=22;
	     datapos.x-=79;
	     setui(DISP_FILEC);
	     datapos.x+=79;
	     gotoxy(wx, wy);
	   }
	   else
	     gotoxy(++wx, wy);
	 }
	 datapos.y = bkpdataposy;
       }
       break;
     case LEFT:
       {
	 uimode = 0;
	 datapos.y += 23 - wherey();

	 if (datapos.x){
	   datapos.x--;
	   if (wx>1)
	     gotoxy(--wx, wy);
	   else{
	     //(linesloaded < 23) ? (datapos.y = 0) : (datapos.y -= 23);
	     datapos.y -= 22;
	     setui(DISP_FILEC);
	     gotoxy(wx, wy);
	   }
	 }
	 datapos.y = bkpdataposy;
       }
       break;
     case INSERT:

       /* Alter insert variable */

       insertstate=!insertstate;

       /* Visual changes to UI */

       insertstate?_setcursortype(_NORMALCURSOR):_setcursortype(_SOLIDCURSOR);

       /* Status bar info update */

       {
	 /* Backup window cursor position */

	 int bkpwx = wherex();
	 int bkpwy = wherey();

	 /* Change data & restore cursor */

	 window(1,25,80,25);
	 gotoxy(73, 1);
	 textattr(0x1F);
	 insertstate?cputs("INS"):cputs("OVR");

	 window(1,2,80,24);
	 gotoxy(bkpwx, bkpwy);
       }
       break;

     /* Jei nebuvo atpazintas, greiciausiai tai bus rasomas simbolis */

     default:

       /* Ar tai tikrai simbolis? Jei taip, bandau irasyti ji. */

       if (!(input & 0xFF00)){
	 modified = TRUE;
	 insertstate ? insert(input & 0x00FF) : overwrite(input & 0x00FF);
       }

   }
   return uimode;
 }

 void setui (int mode){
   switch (mode){
     case COMMAND:
       {
	 char cmdin[80];
	 int pcret;

	 /* Backup Cursor Position */

	 int bkpx = wherex();
	 int bkpy = wherey();

	 /* Init. command line */

	 gotoxy(1, 25);
	 window(1,25,80,25);
	 textbackground(BLUE);
	 textcolor(WHITE);
	 clrscr();
	 putch('>');

	 /* Wait for input */

	 cmdin[0] = 78;
	 if (!(pcret=proccmd(cgets (cmdin)))){

	   /* Jei ivykdyti nepavyko */

	   textbackground (BLUE);
	   textcolor(RED);
	   window (1,25,80,25);
	   clrscr();

	   cprintf ("Can't execute command. Type '?' for help.");
	   getch();

	   textcolor(WHITE);
	   clrscr();
	 }

	 setui(MAIN_WINDOW);
	 window(1,2,80,24);
	 if (pcret!=PR_NORST)
	   gotoxy(bkpx, bkpy);

       }
       break;
     case MAIN_WINDOW:
       {
	 char *fname83o;
	 int x;

	 /* Draw Statusbar (TOP & BOTTOM) */

	 textbackground(BLUE);
	 window(1,1,80,1);
	 clrscr();
	 window(1,25,80,25);
	 clrscr();
	 window(1,1,80,25);

	 /* Get 8+3 file name */

	 for (x = strlen(fdata.fname); x; x--){
	   if(fdata.fname[x] == '\\' || fdata.fname[x] == '/'){
	    x++;
	    break;
	   }
	 }
	 fname83o = &fdata.fname[x];

	 /* Top */

	 textcolor(WHITE);
	 cprintf("File: %s", fname83o);
	 gotoxy(25, 1);
	 cprintf("Size: %lu", fdata.size);
	 gotoxy(49, 1);
	 cprintf("Position: ???%% (???:??????????)");

	 /* Bottom */

	 gotoxy(1, 25);
	 cprintf("Press <ESC> to enter command");

	 gotoxy(73, 25);
	 cputs("INS ");
	 putch('R');
	 if (fdata.ReadOnly)
	   putch('O');
	 else
	   putch('W');

       }
       break;

     case CLEAR_MAINW:

       /* Main window */

       window(1, 2, 80, 24);
       textbackground(BLACK);
       clrscr();
       break;

     case DISP_FILEC:
       {

	 /* Clear main text window */

	 setui(CLEAR_MAINW);

	 /* Display text in main window */

	 if(fdata.failas!=NULL){
	   int winln = 1;

	   _wscroll=FALSE;
	   for(;(datapos.y < linesloaded)&(winln < 24); datapos.y++, winln++){
	     char winline[81];
	     int x;
	     if (strlen(data[datapos.y]) >= datapos.x){
	       if (data[datapos.y][0]==0)
		 continue;
	       _fmemcpy(MK_FP(FP_SEG(winline), FP_OFF(winline)), &data[datapos.y][datapos.x], 80);
	       winline[80] = 0;
	       for (x=0; (x < 80)&&(winline[x]!='\n')&&(winline[x]!='\r'); x++);
	       winline[x]=0;
	       cputs(winline);
	       if (winln < 23 && datapos.y < linesloaded-1)
		 cputs("\n\r");
	     }
	     else
	       cputs("\n\r");
	   }
	   _wscroll=TRUE;
	   if (winln == 24)
	     datapos.y--;
	 }
       }
   }
 }

 unsigned long int getfilesize (FILE *failas){
   unsigned long int size;
   fseek(failas, 0, SEEK_END);
   size = ftell(failas);
   rewind(failas);
   fdata.size = size;
   return size;
 }

 BOOL proccmd (char *cmd){
   BOOL result = TRUE;

   switch (cmd[0]){
     case 'h' :
     case 'H' :
     case '?' : help(); break;

     case 0x1B: break;

     case 'n' :
     case 'N' :
      {

       /* Create New */

       /* Check command syntax */

       if ((strlen(cmd) >= 3) && (cmd[1]==' ')){

	 /*  Save surrent file */

	 if (savemsg()){
	   BOOL overwrite=FALSE;

	   /* Clear main window */

	   textattr(0x0F);
	   window (1,2,80,24);
	   clrscr();

	   /* Unload & Close prev. file */

	   freedatamem();
	   fclose(fdata.failas);
	   fdata.failas = NULL;
	   strcpy(fdata.fname, "(New)");
	   fdata.size = 0;
	   fdata.ReadOnly = FALSE;

	   while(fdata.failas == NULL){

	     /* File exist? */

	     if (((fdata.failas=fopen(&cmd[2], "r"))==NULL)||overwrite){

	       /* If not exist, then try to create new file */

	       if ((fdata.failas=fopen(&cmd[2], "w+")) == NULL){
		 window(1,25,80,25);
		 textattr(0x14);
		 clrscr();
		 cprintf("Failed!\a");
		 getch();
		 break;
	       }
	       else{
		 datapos.x=datapos.y=linesloaded=0;
		 strcpy(fdata.fname, &cmd[2]);
	       }
	     }

	     /* Question: Overwrite file if exist? */

	     else{
	       char choice=0;

	       while (choice!='Y' && choice!='y' && choice!='N' && choice!='n'){
		 fclose(fdata.failas);
		 window(1,25,80,25);
		 textattr(0x1F);
		 clrscr();
		 cprintf ("File Exist. \aOverwrite? [Y/N]: ");
		 choice = getche();
		 if (choice == 'y' && choice == 'Y')
		   overwrite = TRUE;
		 else
		   overwrite = -1;
	       }
	       if (overwrite == -1){
		 overwrite = FALSE;
		 break;
	       }
	     }
	   }
	 }

       }

      }
     break;
     case 'o' :
     case 'O' :

       /* Check command syntax */

       if ((strlen(cmd) >= 3) && (cmd[1]==' ')){

	 /*  Save surrent file */

	 if (savemsg()){

	   /* Clear main window */

	   textattr(0x0F);
	   window (1,2,80,24);
	   clrscr();

	   /* Unload & Close prev. file. Erase file information. */

	   freedatamem();
	   fclose(fdata.failas);
	   fdata.failas = NULL;
	   strcpy(fdata.fname, "(New)");
	   fdata.size = 0;
	   fdata.ReadOnly = FALSE;

	   /* Try to open required file */

	   /* ReadWrite if available */

	   if ((fdata.failas = fopen (&cmd[2], "r+")) == NULL){
	     if ((fdata.failas = fopen (&cmd[2], "r")) == NULL){

	       /* Can't open file */

	       window (1,25,80,25);
	       textattr(0x14);
	       clrscr();

	       cprintf ("Can't open file!\a");
	       getch();
	     }
	     else
	       fdata.ReadOnly = TRUE;
	   }

	   /* Jei failas atidarytas sekmingai, tai... */

	   if (fdata.failas!=NULL){

	     /* Duomenys apie sekmingai atidaryta faila */

	     fdata.size = getfilesize(fdata.failas);
	     strcpy (fdata.fname, &cmd[2]);

	     /* Loading file into memory */

	     loadfile(fdata.failas);

	   }

	   /* Restore cursor position, refresh main window */

	   setui(MAIN_WINDOW);
	   setui(DISP_FILEC);
	   datapos.x=datapos.y=0;
	   window (1,2,80,24);
	   gotoxy(1,1);
	   result = PR_NORST;
	 }
       }
      break;

     case 's' :
     case 'S' :
       {
	 char *sfname = NULL;

	 if (cmd[1] == ' '){
	   if ((sfname = (char*)malloc(128)) == NULL){
	     errormsg(OUTOFNEARMEMORY);
	     pexit(FALSE);
	   }
	   strcpy (sfname, &cmd[2]);
	 }
	 else if (cmd[1] == 0);
	 //  sfname[0]=0;

	 else{
	   errormsg(CMDSYNTAX);
	   break;
	 }

	 if (!save(sfname))
	   errormsg(SAVEFILEFAILED);

	 modified = FALSE;
       }
       break;
     case 'q' :
     case 'Q' : pexit(TRUE); break;

     default  : result = FALSE;
   }

   return result;
 }

 void help (void){
  WINDOW helpwnd;
  int inp;
  char *videobkp = NULL;

  /* Backup video */

  if ((videobkp = (char*)malloc (2304))==NULL){
    window(1,2,80,24);
    textbackground(RED);
    textcolor(WHITE);
    clrscr();
    //cprintf("Out of memory. Save your work and try to restart program!\a");
    errormsg(OUTOFNEARMEMORY);
    pexit(FALSE);
  }

  gettext(5,5,77,21,videobkp);

  /* Help Window */

  helpwnd.x1=5;
  helpwnd.y1=5;
  helpwnd.x2=75;
  helpwnd.y2=20;
  helpwnd.boxattr=0x3E;
  helpwnd.title="Help";
  helpwnd.shadow=TRUE;

  CreateWindow(&helpwnd);

  /* Quick Help Text */

  cprintf (" COMMON OPERATIONS:\n\r");
  cprintf (" H, ? - Help\n\r");
  cprintf (" Q    - Quit\n\r");
  cprintf (" ESC and ENTER - cancels\n\r");
  cprintf (" FILE OPERATIONS:\n\r");
  cprintf (" N <file name> - Create New\n\r");
  cprintf (" O <file name> - Open File\n\r");
  cprintf (" S [file name] - Save [As] File\n\r");
  cprintf (" Coming soon");

  CreateButton(30,13, 10, 0x4F, "OK", TRUE);

  /* Waiting for ENTER */

  do{
    inp = getch();
    if (!inp)
      inp = getch();
  }
  while (inp!=ENTER);

  /* Restoring video and cursor */

  puttext(5,5,77,21,videobkp);
  free(videobkp);
  videobkp=NULL;

 }

 void freedatamem (void){

   /* Kursorius nustatomas i pradine pozicija */

   datapos.x = datapos.y = 0;

   /* Atlaisvinamos eilutes */

   while (linesloaded){
     farfree(data[linesloaded-1]);    //!!!!!
     data[linesloaded-1] = NULL;
     linesloaded--;
   }

   /* Atlaisvinama eiluciu pointeriu atmintis */

   farfree (data);
   data = NULL;
 }

int getinput(void){
  int input;
  fflush(stdin);
  if(!(input = getch())){
    input = getch();
    input = input << 8;
  }
  return input;
}

void updateposinfo (void){
 int xbkp, ybkp;
 float position = datapos.y;
 float loaded = linesloaded-1;
 float posperc;

 if (linesloaded-1)
   posperc = position/loaded*100;
 else
   posperc = 100;

 xbkp = wherex();
 ybkp = wherey();

 window(1,1,80,25);
 gotoxy(49, 1);
 textattr(0x1F);
 cprintf("Position: %3.0f%% (%0.3d:%0.10lu)", posperc, datapos.x, datapos.y);
 gotoxy(71, 25);
 if (modified)
   putch ('*');
 window(1,2,80,24);
 gotoxy(xbkp, ybkp);
}

void insert (char symbol){
  BOOL fail = FALSE;
  char bkpstr[256];

  _fstrcpy(MK_FP(FP_SEG(bkpstr), FP_OFF(bkpstr)), data[datapos.y]);

  /* Jei ENTER, tai pereiti i nauja eilute */

  if (symbol == ENTER) {
    if (insertline()){
      datapos.x=0;
      datapos.y++;
      gotoxy(0, wherey()+1);
    }
    else
      fail = TRUE;
  }

  /* Jei BACKSPACE, tai trinti simboli */

  else if (symbol == ENTER)
    delsymbol();

  /* Jei tai simbolis, tai tikrinu ar galima ivesti */

  else if ((datapos.x + strlen(&data[datapos.y][datapos.x]) <= 255) && (!fdata.ReadOnly)){ //!!! =

    /* Jei iterpta ne eilutes pabaigoje */

    if (datapos.x <= _fstrlen(data[datapos.y])){ //!!!
      if ((data[datapos.y]=(char far*)farrealloc(data[datapos.y], _fstrlen(data[datapos.y])+2))==NULL)
	fail=TRUE;
      else{
	_fstrcpy(data[datapos.y], MK_FP(FP_SEG(bkpstr),FP_OFF(bkpstr)));

	/* Backup line from cursor x */

	_fstrcpy(MK_FP(FP_SEG(bkpstr), FP_OFF(bkpstr)), &data[datapos.y][datapos.x]);

	/* Insert symbol, restore */

	data[datapos.y][datapos.x] = symbol;
	_fstrcpy(&data[datapos.y][datapos.x+1], MK_FP(FP_SEG(bkpstr), FP_OFF(bkpstr)));
      }
    }

    /*

       Jei iterpta eilutes pabaigoje, '\0' iki iterpiamo simbolio
       keiciu ' '.

    */

    else {
      int x = _fstrlen (data[datapos.y]);

      if ((data[datapos.y]=(char far*)farrealloc(data[datapos.y], datapos.x+2))==NULL)
	fail = TRUE;
      else {
	_fstrcpy(data[datapos.y], bkpstr);

	do
	  data[datapos.y][x++] = ' ';
	while (x!=datapos.x);
	data[datapos.y][x] = symbol;
	data[datapos.y][x+1] = 0;
      }
    }

    if (datapos.x<255){
      datapos.x++;
      gotoxy(wherex()+1, wherey());
    }
  }

  else if (fail){
    errormsg(OUTOFMEMORY);
    return;
  }

  /* Jei netenkino antrosios salygos, tai nera galimybes rasyti. Beep. */

  else {

    /* Beep */

    sound(2000);
    delay (300);
    nosound();

    return;
  }

  /* -------------------------------------------------- */

  {
    /* Creating position coord. backups */

    int bkpwx = wherex();
    int bkpwy = wherey();
    CURSOR bkppos = datapos;

    /* Refresh */

    datapos.x -= wherex()-1;
    datapos.y -= wherey()-1;
    setui(DISP_FILEC);

    /* Restore */

    datapos = bkppos;
    gotoxy(bkpwx, bkpwy);

  }

}

void overwrite (char symbol){

}

BOOL insertline (void){

}

void delsymbol (void){

}

BOOL save (char *fname){
  int y;
  char tmpname[128];
  char rndnum[5];
  FILE *tmp;
  BOOL force = FALSE;
  BOOL success = TRUE;
  BOOL overwrite = FALSE;

  /* Ar duotas failas neegzistuoja? */

  if (fname != NULL){
    FILE *file;

    if ((file = fopen (fname, "r")) != NULL){
      fclose(file);

      /* Failas egzistuoja. Ar perrasyti ji? */

      if (!ovrfmsg()){
	return FALSE;
      }
    }
  }

  /* Generuoju laikino failo pavadinima */

  strcpy(tmpname, getenv("TEMP"));
  strcat(tmpname, "\\AFE_");
  strcat(tmpname, itoa(random(0x10000), rndnum, 16));
  strcat(tmpname, ".tmp");

  /* Atidarau laikina faila */

  if ((tmp = fopen(tmpname, "w")) == NULL){
    putch('\a');
    errormsg(TMPCREATIONFAILURE);
    tmp = fdata.failas;
    force = TRUE;
    rewind(tmp);
  }

  /* Saugau duomenis i laikina faila */

  for (y = 0; y != linesloaded; y++){
    if (fputs(data[y], tmp) == EOF){
      success = FALSE;
      break;
    }
    fputs("\r\n", tmp);
  }

  /* Jei nebuvo rasyta tiesiai i originalu faila, tai uzdaryti
     tmp faila ir ji irasyti vietoje reikiamo failo             */

  if (!force){
    fclose(tmp);

    if (success) {
      fclose(fdata.failas);

      /* Jei saugoma i originala */

      if (fname == NULL)
	remove (fdata.fname);

      /* Jei saugoma i nauja faila */

      else
	strcpy(fdata.fname, fname);

      /* TMP failo kopijavimas ir trinimas */

      if (!filecopy(fdata.fname, tmpname))
	success = FALSE;
      fdata.failas = fopen (fdata.fname, fdata.ReadOnly ? "r" : "r+"); //!!!

      /* Reopen */

      fdata.ReadOnly = FALSE;
      if ((fdata.failas = fopen(fdata.fname, "r+")) == NULL){
	fdata.ReadOnly = TRUE;
	if ((fdata.failas = fopen(fdata.fname, "r")) == NULL){
	  errormsg(REOPENFILEFAILED);
	  success = FALSE;
	}
      }
    }
  }

  if (success)
    modified = FALSE;

  return success;
}

BOOL filecopy(char *dst, char *src){
  FILE *srcf = NULL, *dstf = NULL;

  if ((srcf = fopen(src, "r")) == NULL)
    return FALSE;
  if ((dstf = fopen(dst, "w+")) == NULL){
    fclose(srcf);
    return FALSE;
  }

  while (!feof(srcf))
    fputc(fgetc(srcf), dstf);

  fclose(srcf);
  fclose(dstf);

  return TRUE;
}

void pexit (BOOL successful){

  /* Failo issaugojimas, jeigu jis buvo modifikuotas */

  while (modified){
    if (savemsg()){
      if (!save(NULL)){
	errormsg(SAVEFILEFAILED);
	pushkey(0x1B);
	pushkey('S');
	pushkey(' ');
	setui(COMMAND);
      }
    }
    else
      break;
  }

  /* Atlaisvinu atminti, uzdarau faila, atstatau iprastas
     konsoles spalvas                                      */

  freedatamem();
  fclose(fdata.failas);
  window(1,1,80,25);
  gotoxy(80,25);
  textattr(0x07);

  /* Informacija apie programos baigties sekminguma  */

  cprintf("\n\rProgram execution was ");
  if (successful)
    cprintf("successful. Returned ERRORLEVEL 0.");
  else
    cprintf("unsuccessful. Returned ERRORLEVEL 1.");
  cprintf("\n\r");

  /* Programos uzdarymas */

  exit(!successful);
}

BOOL savemsg(void){
  char *videobkp = NULL;
  WINDOW savewin;
  BOOL save = TRUE;
  int input;

  /* Nustatomi kuriamo lango parametrai */

  savewin.x1 = 20;
  savewin.y1 = 7;
  savewin.x2 = 60;
  savewin.y2 = 13;
  savewin.boxattr = 0x2F;
  savewin.title = "Warning";
  savewin.shadow = TRUE;

  /* Rezervuojama atmintis vaizdo, kuris bus perrasytas, buferiui */

  videobkp = (char *)malloc(588);

  /* Kuriamas langas */

  window(1,1,80,25);
  if (videobkp != NULL)
    gettext(20, 7, 62, 14, videobkp);
  CreateWindow(&savewin);
  window(savewin.x1+2, savewin.y1+2, savewin.x2-2, savewin.y2-2);

  /* Isvedamas pranesimas */

  cprintf ("Save changes?");
  CreateButton(5, 3, 15, 0x1F, "Yes", TRUE);
  CreateButton(23, 3, 10, 0x1F, "No", FALSE);

  do{
    input = getinput();
    switch(input){
      case ENTER:
      case SPACE:
	break;
      case LEFT:
      case RIGHT:
	if (save){
	  DeselectButton(5,3,15); //Yes
	  SelectButton(23,3,10);  //No
	  save = FALSE;
	}
	else{
	  DeselectButton(23,3,10);//No
	  SelectButton(5,3,15);   //Yes
	  save = TRUE;
	}
	break;
      case 'Y':
      case 'y':
	save = TRUE;
	break;
      case 'N':
      case 'n':
	save = FALSE;
    }
  }
  while((input != ENTER)&&(input != SPACE)&&
	(input != 'Y')  &&(input != 'y'  )&&
	(input != 'N')  &&(input != 'n'  ));
  if (videobkp != NULL){
    puttext(20, 7, 62, 14, videobkp);
    free(videobkp);
  }
  return save;
}


BOOL ovrfmsg(char *fname){
  WINDOW ovrfwin;
  char *videobkp = NULL;
  int input;
  BOOL overwrite = FALSE;

  /* Nustatomi kuriamo lango parametrai */

  ovrfwin.x1 = 20;
  ovrfwin.y1 = 7;
  ovrfwin.x2 = 60;
  ovrfwin.y2 = 14;
  ovrfwin.boxattr = 0x2F;
  ovrfwin.title = "Warning";
  ovrfwin.shadow = TRUE;

  /* Rezervuojama atmintis vaizdo, kuris bus perrasytas, buferiui */

  videobkp = (char *)malloc(672);

  /* Kuriamas langas */

  window(1,1,80,25);
  if (videobkp != NULL)
    gettext(20, 7, 62, 14, videobkp);
  CreateWindow(&ovrfwin);
  window(ovrfwin.x1+2, ovrfwin.y1+2, ovrfwin.x2-2, ovrfwin.y2-2);

  /* Isvedamas pranesimas */

  cprintf ("File \"%s\" exist. \n\rOverwrite?!", fname);
  CreateButton(5, 4, 10, 0x1F, "Yes", FALSE);
  CreateButton(18, 4, 15, 0x1F, "No", TRUE);

  do{
    input = getinput();
    switch(input){
      case ENTER:
      case SPACE:
	break;
      case LEFT:
      case RIGHT:
	if (!overwrite){
	  DeselectButton(18,4,15); //No
	  SelectButton(5,4,10);    //Yes
	  overwrite = TRUE;
	}
	else{
	  DeselectButton(5,4,10);  //Yes
	  SelectButton(18,4,15);   //No
	  overwrite = FALSE;
	}
	break;
      case 'Y':
      case 'y':
	overwrite = TRUE;
	break;
      case 'N':
      case 'n':
	overwrite = FALSE;
    }
  }
  while((input != ENTER)&&(input != SPACE)&&
	(input != 'Y')  &&(input != 'y'  )&&
	(input != 'N')  &&(input != 'n'  ));
  if (videobkp != NULL){
    puttext(20, 7, 62, 14, videobkp);
    free(videobkp);
  }
  return overwrite;
}

void pushkey(char key){
  asm{
    MOV AH, 5
    MOV CL, key
    INT 0x16
  }
}

// -------------------- [ EOF "MAIN.C" ] -----------------------