#include "errors.h"

void errormsg (int errnum){
  char *videobkp = NULL;
  WINDOW errwin;

  /* Nustatomi kuriamo lango parametrai */

  errwin.x1 = 20;
  errwin.y1 = 7;
  errwin.x2 = 60;
  errwin.y2 = 18;
  errwin.boxattr = 0x4E;
  errwin.title = "Error";
  errwin.shadow = TRUE;

  /* Rezervuojama atmintis vaizdo, kuris bus perrasytas, buferiui */

  videobkp = (char *)malloc(1008);

  /* Kuriamas langas, isvedamas klaidos kodas */

  window(1,1,80,25);
  if (videobkp != NULL)
    gettext(20, 7, 62, 19, videobkp);
  CreateWindow(&errwin);
  window(errwin.x1+2, errwin.y1+2, errwin.x2-2, errwin.y2-2);
  cprintf("0x%0.4X: ", errnum);

  /* --- Error detection SWITCH --- */

  switch(errnum){
    case OUTOFMEMORY:
      cprintf ("Out of far memory! Probably file too big to fit in memory. "
	       "Solution: use smaller files or try better text editor."
	       "SAVE YOUR WORK and program will close.");
      break;
    case OUTOFNEARMEMORY:
      cprintf ("Out of near memory! Save your work and try to restart program.");
      break;
    case OPENFILEFAILED:
      cprintf ("Cannot open file.");
      break;
    case SAVEFILEFAILED:
      cprintf ("Cannot save file.");
      break;
    case REOPENFILEFAILED:
      cprintf ("Cannot reopen file.");
      break;
    case TMPCREATIONFAILURE:
      cprintf ("Temporary file creation failure.");
      break;
    case CMDSYNTAX:
      cprintf ("Syntax error.");
      break;
    default: cprintf ("Unknown error!");
  }

  if ((errnum & 0xF0) == 0x10){
    errormsg(OUTOFMEMORY);
    pexit(FALSE);
    freedatamem();
  }

  CreateButton((errwin.x2-errwin.x1)/2-3,
		errwin.y2-errwin.y1-3, 6, 0x1F, "OK", TRUE);
  while (getch()!=0x000D);

  if (videobkp != NULL)
    puttext(20, 7, 62, 19, videobkp);
  free(videobkp);
}